USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'{DBOwner}qi_Countries') AND type in (N'U'))
BEGIN
	CREATE TABLE {DBOwner}qi_Countries
	(
		IC bigint NOT NULL,
		U int NOT NULL,
		LastUpdate datetime NOT NULL,
		CodeA2 nvarchar(2) {DBCollate} NOT NULL,
		CodeA3 nvarchar(3) {DBCollate} NOT NULL,
		ISOName nvarchar(100) {DBCollate} NOT NULL,
		ShortName nvarchar(60) {DBCollate} NULL,
		FullName nvarchar(100) {DBCollate} NULL,
		UserName nvarchar(100) {DBCollate} NULL,
		[Default] tinyint NULL
	)  ON [PRIMARY]

	ALTER TABLE {DBOwner}qi_Countries ADD CONSTRAINT PK_qi_Countries PRIMARY KEY CLUSTERED 
	(
		IC,
		U
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END

IF (NOT EXISTS (SELECT * FROM syscolumns WHERE [name] = 'CountryIC' AND [id] = OBJECT_ID('{DBOwner}qi_Organizations')))
BEGIN
	ALTER TABLE {DBOwner}qi_Organizations ADD
		CountryIC bigint NULL,
		CountryU int NULL
END


IF (NOT EXISTS (SELECT * FROM syscolumns WHERE [name] = 'CountryIC' AND [id] = OBJECT_ID('{DBOwner}qi_Persons')))
BEGIN
	ALTER TABLE {DBOwner}qi_Persons ADD
		CountryIC bigint NULL,
		CountryU int NULL,
		RecipientCountryIC bigint NULL,
		RecipientCountryU int NULL
END

IF (NOT EXISTS (SELECT * FROM syscolumns WHERE [name] = 'CountryIC' AND [id] = OBJECT_ID('{DBOwner}qi_TransportLocations')))
begin
	ALTER TABLE {DBOwner}qi_TransportLocations ADD
		CountryIC bigint NULL,
		CountryU int NULL
END

IF (NOT EXISTS (SELECT * FROM syscolumns WHERE [name] = 'CustomerCountryIC' AND [id] = OBJECT_ID('{DBOwner}qi_Orders')))
BEGIN
	ALTER TABLE {DBOwner}qi_Orders ADD
		CustomerCountryIC bigint NULL,
		CustomerCountryU int NULL,
		RecipientCountryIC bigint NULL,
		RecipientCountryU int NULL
END

GO
COMMIT